#include <SoftwareSerial.h>

#define UPS_RX 10
#define UPS_TX 11
#define RELAY_PIN 8   // Relé bemenet, aktív HIGH: megszakítja a 230V-ot
#define MAX_LEN 64

SoftwareSerial upsSerial(UPS_RX, UPS_TX, true); // UPS kapcsolat

String upsBuffer = "";
String apcBuffer = "";
unsigned long testStartMillis = 0;
bool isBatteryTestRunning = false;
byte upsStatusByte = 0x08;
String inp="000.0";
String outp="000.0";
String battery_voltage="00.0";
String hz="00.0";
String battery_charge="00";
String load="00";
String stat="00";
String upsNjoy="";

byte buffer[MAX_LEN];
int index = 0;

void setup() {
	Serial.begin(2400);         // Host (APC) kapcsolat
	upsSerial.begin(2400);      // UPS kapcsolat
	pinMode(RELAY_PIN, OUTPUT);
	digitalWrite(RELAY_PIN, LOW);  // Alapértelmezett: 230V be van kapcsolva
}

void loop() {

  //ups lekérdezése
  upsNjoy=upsRead();
  inp = getValue(upsNjoy, ',', 0);
  outp = getValue(upsNjoy, ',', 1);
  hz=getValue(upsNjoy, ',', 2);
  battery_voltage=getValue(upsNjoy, ',', 3);
  battery_charge=getValue(upsNjoy, ',', 4);
  load=getValue(upsNjoy, ',', 5);
  stat=getValue(upsNjoy, ',', 6);


  
	// Olvasás APC irányból
	while (Serial.available()) {
		char c = Serial.read();
   apcBuffer += c;
		if (apcBuffer[0]!="" ) {
			processApcCommand(apcBuffer);
			apcBuffer = "";
		} 		
	}


	if (isBatteryTestRunning) {
		if (millis() - testStartMillis >= 5000) {
			digitalWrite(RELAY_PIN, LOW); // visszakapcsoljuk a 230V-ot
			isBatteryTestRunning = false;
		}
	}
 
}

int hexByte(String hexStr) {
	return strtol(hexStr.c_str(), NULL, 16);
}

//ups kiolvasása
String upsRead(){
  String result="";
  upsSerial.print("QS\r");
  delay(100);
  if(upsSerial.available()){
  while (upsSerial.available()) {
    byte b = upsSerial.read();
    if (index < MAX_LEN) buffer[index++] = b;

    if (b == 0x0D) {  // Ha CR karakter, vége az UPS válasznak
      result = parseUPSFromBytes(buffer, index);
      //Serial.println(result);
      index = 0; // reset
      return result;
    }
  }
  
}else{
  result="000.0,000.0,00.0,00.0,00,00,00";
    return result;
  }
}

void processApcCommand(String cmd) {
	cmd.trim();

 switch (cmd[0]) {
      case 'Y': // Smart mode aktiválása
        Serial.print("SM\r\n");
        break;

      case 0x01: // Ctrl-A (UPS azonosító)
        Serial.print("NJOY Horus 2000\r\n"); //ups neve
        break;

      case 'a': // Ctrl-Z (funkciólista) case 0x1A
        Serial.print("3.!$%+?=#|.\x01\x0E\x1A\')+-89@ABDEFGKLMNOPQRSUVWXYZabcdefgjklmnopqrsuxyz~\r\n"); // kamu funkciók
        break;

      
      case 'Q': // Állapot lekérdezés (Q vagy Q1)
      case 'q': 
        //Serial.print("("+inp+" "+outp+" "+load+" "+battery_voltage+" 036.0 "+hz+" OL)\r\n");
        Serial.println(stat);
        break;
        
      case 'B': // Akkufeszültség
        Serial.println(battery_voltage); // 27.4V
        break;
        
      case 'b': // verzió szám
        Serial.print("21.3.I\r\n"); 
        break;  

      case 'F': // Frekvencia
        Serial.println(hz); // 50Hz
        break;

      case 'G': // Átváltás oka (Reason for transfer)
        Serial.print("O\r\n"); // Normal Operation
        break;

      case 'n': // Átváltás oka (Reason for transfer)
        Serial.print("NS9847001053\x00\x00\r\n"); // Normal Operation
        break;

      case 'L': // bemenet feszültség
        Serial.println(inp); 
        break;
      case 'O': // kimenet feszültség
        Serial.println(outp); 
        break;

      case 'V': // Firmware verzió
        Serial.print("DWI"); //v12.5.D\r\n volt
        break;

      case 'C': // Hőmérséklet
        Serial.print("036.0\r\n");
        break;
/*
      case 'N': // UPS modellnév
        Serial.print("NJOY Horus 2000\r\n");
        break;*/

      case 'P': // terhelés
        Serial.println(load+".0"); // 100%
        break;
      case 'f': // Akkumulátor töltöttség
        Serial.println(battery_charge+".0"); // 100%
        break;

      case '#': // Hang kikapcsolása
      upsSerial.print("Q\r");
        Serial.print("OK\r\n");
        break;

      case 'W': // Akkuteszt indítása  
        runBatteryTest();
        Serial.print("OK\r\n");
        
        break;

      case 'M':
        Serial.print("240.0\r\n");
        break;  
      case 'N':
        Serial.print("220.0\r\n");
        break;  
      case 'j':
        Serial.println("0327:");
        break;
      case 'g':
        Serial.println("024");
        break;  

      case '9':
      if(stat=="08"){
        Serial.print("FF\r\n");
      }else{
        Serial.print("00\r\n");
        }
        break; 

      // "(C) APCC\r\n"  
      case 'y':
        Serial.print("(C) APCC\r\n");
        break; 

      default:
        Serial.print("NA\r\n"); // Ismeretlen parancs
        break;
    }

}

void runBatteryTest() {
	digitalWrite(RELAY_PIN, HIGH);  // megszakítjuk a bemenetet
	testStartMillis = millis();     // elindítjuk az időzítést
	isBatteryTestRunning = true;
}

 String getValue(String data, char separator, int index)
{
  int found = 0;
  int strIndex[] = {0, -1};
  int maxIndex = data.length()-1;

  for(int i=0; i<=maxIndex && found<=index; i++){
    if(data.charAt(i)==separator || i==maxIndex){
        found++;
        strIndex[0] = strIndex[1]+1;
        strIndex[1] = (i == maxIndex) ? i+1 : i;
    }
  }

  return found>index ? data.substring(strIndex[0], strIndex[1]) : "";
}


String parseUPSFromBytes(byte* data, int len) {
  if (len < 2 || data[0] != '#') return "Invalid";

  // 1. Hex string építése szóközökkel
  String hexStr = "";
  for (int i = 1; i < len; i++) {
    String h = String(data[i], HEX);
    if (h.length() < 2) h = "0" + h;
    if (h == "20") h = " ";
    hexStr += h;
  }

  // 2. Megegyezik az előző parseUPS() logikával
  return parseHexUPSString(hexStr);
}


String parseHexUPSString(String hexStr) {
 
  String tokens[32];
  int tokenCount = 0;

  while (hexStr.length() > 0 && tokenCount < 32) {
    int idx = hexStr.indexOf(' ');
    if (idx == -1) {
      tokens[tokenCount++] = hexStr;
      break;
    } else {
      tokens[tokenCount++] = hexStr.substring(0, idx);
      hexStr = hexStr.substring(idx + 1);
    }
  }

  for (int i = 0; i < tokenCount; i++) {
    tokens[i].replace("2800", "0D");
    tokens[i].replace("2801", "11");
    tokens[i].replace("2802", "13");
    tokens[i].replace("2803", "0A");
    tokens[i].replace("2804", "20");
  }

 
String ad1 = tokens[0].substring(0, 2);
String be1 = tokens[0].substring(2, 4);
float inputV = calcVoltage(ad1, be1, tokens[1]);

String ad2 = tokens[2].substring(0, 2);
String be2 = tokens[2].substring(2, 4);
float outputV = calcVoltage(ad2, be2, tokens[3]);


 /* float inputV = calcVoltage(tokens[0].substring(0, 2), tokens[0].substring(2, 2), tokens[1]);
  float outputV = calcVoltage(tokens[2].substring(0, 2), tokens[2].substring(2, 2), tokens[3]);*/
  int loadPercent = strtol(tokens[4].c_str(), NULL, 16);

  String hi = tokens[5].substring(0, 2) + tokens[5].substring(2, 2);
  String j = tokens[6].substring(0, 2);
  String kl = tokens[6].substring(2, 2) + tokens[6].substring(4, 2);
  float freq = calcFrequency(hi, j, kl);
  if (freq > 99.9f) freq = 99.9f;

  float batVoltage = calcBatteryVoltage(tokens[7], tokens[8]);
  String statusByte = tokens[tokenCount - 1];
  String modeHex = statusByte.substring(0, 2);
  String mode = getMode(modeHex);
  int batCap = calculateBatteryCapacity(batVoltage, loadPercent, mode);

  String result = String(inputV, 1) + "," + String(outputV, 1) + "," + String(freq, 1) + ",";
  result += String(batVoltage, 1) + "," + String(batCap) + "," + String(loadPercent) + "," + mode;
  return result;
}
float calcVoltage(String ad, String be, String cf) {
  int param1 = strtol((ad + be).c_str(), NULL, 16);  // pl. "7201" = 29185
  int param2 = strtol(cf.c_str(), NULL, 16);         // pl. "6C" = 108

  long product = (long)param1 * (long)param2;        // 32 bites szorzás
  float voltage = (float)product / 51.0 / 256.0;

  return voltage;
}


float calcFrequency(String hi, String j, String kl) {
  int p1 = strtol(hi.c_str(), NULL, 16);
  int p2 = strtol((j + kl).c_str(), NULL, 16);
  if (p1 == 0) return 0.0f;
  return (float)p2 / p1;
}

float calcBatteryVoltage(String hi, String lo) {
  int combined = strtol((lo + hi).c_str(), NULL, 16);
  return combined / 560.0f;
}

String getMode(String hex) {
  hex.toUpperCase();
  if (hex == "0B") return "50"; //Standby
  if (hex == "01") return "00"; //Battery test
  if (hex == "08" || hex == "09" || hex == "02") return "08"; //online
  if (hex == "3F" || hex == "0D") return "10"; //battery
  return "10"; //fault
}

int calculateBatteryCapacity(float vBat, int load, String mode) {
  if (mode == "08" || mode == "50") {
    if (vBat < 22.5f) return 0;
    if (vBat >= 27.0f) return 100;
    if (vBat >= 26.5f) return 95;
    return (int)(90.0f * (vBat - 22.5f) / 4.0f);
  }
  if (mode == "10" || mode == "00") {
    if (load < 20) {
      if (vBat >= 26.5f) return 100;
      if (vBat > 21.0f) return (int)(100.0f * (vBat - 21.0f) / 5.5f);
    } else {
      if (vBat >= 25.5f) return 100;
      if (vBat > 21.0f) return (int)(100.0f * (vBat - 21.0f) / 4.5f);
    }
    return 0;
  }
  return 0;
}
