#include <SparkFunDS1307RTC.h>
#include <Wire.h>
#include <TM1637Display.h>
const int CLK = 2; //CLK láb beállítása
const int DIO = 3; //DIO láb beállítása
TM1637Display display(CLK, DIO); //kijelző inicializálás
int light = A0;
char incoming;

uint8_t data[] = {0x0, 0x0, 0x0, 0x0};
uint8_t text[] = {
  SEG_G,                                            // -
  SEG_G,                                            // -
  SEG_G,                                            // -
  SEG_G,                                            // -
  SEG_F | SEG_E | SEG_G | SEG_D | SEG_C,            // b
  SEG_C | SEG_D | SEG_E | SEG_G,                    // o
  SEG_F | SEG_E | SEG_D ,                           // l
  SEG_B | SEG_C | SEG_D | SEG_E | SEG_G,            // d
  SEG_C | SEG_D | SEG_E | SEG_G,                    // o
  SEG_F | SEG_A | SEG_B | SEG_G | SEG_C | SEG_D,    // g
  SEG_G,                                            // -
  SEG_G,                                            // -
  SEG_A | SEG_F | SEG_G | SEG_C | SEG_D,            // S
  SEG_A | SEG_B | SEG_G | SEG_E | SEG_D,            // Z
  SEG_C | SEG_D | SEG_E,                            // u
  SEG_F | SEG_E | SEG_D,                            // l
  SEG_C,                                            // i
  SEG_C | SEG_E | SEG_G,                            // n
  SEG_E | SEG_F | SEG_A | SEG_B | SEG_G | SEG_C,    // A
  SEG_G | SEG_B | SEG_A | SEG_F | SEG_E,            // p
  SEG_C | SEG_D | SEG_E | SEG_G,                    // o
  SEG_F | SEG_G | SEG_E | SEG_D,                    // t
  SEG_G,                                            // -
  SEG_G,                                            // -
  SEG_G,                                            // -
  SEG_G,                                            // -
};

void setup() {
  rtc.begin(); // óra indul :)
  //bluetooth modul beállítás
  delay(2000);
  Serial.begin(38400);
  delay(1000);
  Serial.println("AT+UART=115200,0,0");
  delay(500);
  Serial.println("AT+POLAR=1,0");
  delay(500);
  Serial.println("AT+NAME=ORA");
  delay(500);
  Serial.println("AT+PSWD=2113");
  delay(500);
  Serial.println("AT+RESET");
  Serial.end();


  Serial.begin(115200); //soros kapcsolat inicializálása
  
  Serial.println("Menu:");
  Serial.println("Ora lekerdez: T");
  Serial.println("Ora beallit: B");
  display.setBrightness(0x0a); //max fényerő
}


void loop() {
  if (Serial.available() > 0) {
    incoming = Serial.read(); // read the incoming byte:
    //Serial.println(incoming);
  }
  if (incoming == 'T') {
    soros_kiirat();
  }
  if (incoming == 'B') {
    beallitas();
  }
  incoming = 'N';
  rtc.update(); //idő lekérdezése
  int fenye = feny();

  int perc = rtc.minute();
  String s_perc = String(perc);
  if (perc < 10) {
    s_perc = "0" + String(perc);
  }
  String ido = String(rtc.hour()) + s_perc;

  if (fenye == 0) {
    display.setBrightness(fenye, false);
    display.setSegments(data);
  } else {
    display.setBrightness(fenye);
    display.showNumberDecEx(ido.toInt(), 0b01000000, false, 4, 0);
  }


  delay(500);
  if (rtc.month() == 1 && rtc.date() == 10) { //ez nem az :-p
    szulinap();
  }
}

//idő beállító funkció
void oraFunction(int ora, int perc, int masodperc, int nap, int naptarinap, int honap, int ev) {
  rtc.set24Hour(); //24 órás működés
  rtc.setTime(masodperc, perc, ora, nap, naptarinap, honap, ev); //idő beállítása

}
void soros_kiirat() {

  rtc.update(); //idő lekérdezése
  //Ki íratás
  Serial.print(rtc.year());
  Serial.print("-");
  Serial.print(rtc.month());
  Serial.print("-");
  Serial.print(rtc.date());
  Serial.print(" ");
  Serial.print(rtc.day());
  Serial.print("nap");
  Serial.print(" ");
  Serial.print(rtc.hour());
  Serial.print(":");
  Serial.print(rtc.minute());
  Serial.print(":");
  Serial.println(rtc.second());
  Serial.println("Menu:");
  Serial.println("Ora lekerdez: T");
  Serial.println("Ora beallit: B");
}
int  soros_beolvas() {
  int x;
  String str;
ures:
  if (Serial.available() > 0) {
    x = Serial.parseInt();
   
  }
  else
  {
    goto ures;
  }
  
  return x;
}
void beallitas() {
  rtc.update(); //idő lekérdezése
  Serial.println("Beallitas menu");
  Serial.print("Ird ide az evet (pl.13):");
  int ev = soros_beolvas();
  if (ev == 0)ev = rtc.year();
  Serial.println(ev);
  Serial.print("Ird ide a honapot (pl.8):");
  int honap = soros_beolvas();
  if (honap == 0)honap = rtc.month();
  Serial.println(honap);
  Serial.print("Ird ide a napot (pl.30):");
  int nap = soros_beolvas();
  if (nap == 0)nap = rtc.date();
  Serial.println(nap);
  Serial.print("Het hanyadik napja szammal(angol):");
  int napnev = soros_beolvas();
  if (napnev == 0)napnev = rtc.day();
  Serial.println(napnev);
  Serial.print("Ird ide az orat:");
  int ora = soros_beolvas();
  if (ora == 0)ora = rtc.hour();
  Serial.println(ora);

  Serial.print("Ird ide a percet:");
  int perc = soros_beolvas();
  if (perc == 0)perc = rtc.minute();
  Serial.println(perc);
  oraFunction(ora, perc, 30, napnev, nap, honap, ev); //2025-04-09 21:09:00 formátum
  soros_kiirat();
}

/////////////////
int feny() {
  int raw_light = analogRead(light);
  int fenyero = map(raw_light, 0, 1023, 0, 7);
  return fenyero;

}


///////////////////
void szulinap() {
  int fenye = feny();

  if (fenye == 0) {
    display.setBrightness(fenye, false);
    display.setSegments(data);
  } else {
    for (int i = 0; i < 27; i++)
    {
      display.setSegments(text + i);
      delay(300);
    }
  }
}
